-- Define our particle characteristics

pAge = Allocate(1) ; -- Allocate a Vec2 velocity member
pStartColor = Allocate(4);

-- Set the particle texture
SetTexture("celebrity");
SetBlendMode(kBlendNormal);

SetNumParticles(20);    -- Create some particles

pPosition:Init(   f2dRotation( fRange(0, 6) ) * fRange(1,5));


pStartColor:Init( fRange(Color(1,1,1,1), Color(1,0,1,1)) );
pScale:Init( fRange(1.0,2.0) );
pUp:Init( f2dRotation( fRange(0,6) ) );

kLifetime = 300;
pColor:Anim( fFade( pAge,
pStartColor, kLifetime, Color(1,1,1,0) ) );



-- Add time to the age
pAge:Anim( pAge+fAge() );

-- Expire particles over 1500 ms old
Anim( fExpire( fGreater(pAge,kLifetime) ) );



-- A function to run as we're executing
-- seconds - how many seconds have elapsed
function Update(seconds)
 CreateParticles( seconds * 20 );
end

